<title>Wallet - Best Leearning</title>

<?php $__env->startSection('css'); ?>
 <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="https://powerworkerearn.com/resources/css/argon.css" type="text/css">
    <link rel="stylesheet" href="https://powerworkerearn.com/resources/css/myapp.css" type="text/css">
    <link rel="stylesheet" href="https://powerworkerearn.com/resources/css/bttn.css" type="text/css">

<style>
    /* General Styling */
    .container-fluid {
        background-color: #f5f7fa;
    }

    .card {
        border-radius: 12px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        transition: transform 0.3s ease-in-out;
    }

    .card:hover {
        transform: scale(1.02);
    }

    .card-header {
        background-color: #007bff;
        color: white;
        padding: 20px;
        border-radius: 12px 12px 0 0;
    }

    .card-body {
        padding: 20px;
        background-color: #ffffff;
        border-radius: 12px 12px 12px 12px;
    }

    h3, h2, h5 {
        font-family: 'Arial', sans-serif;
        margin-bottom: 15px;
    }

    /* Marquee Styling */
    .alert {
        background: linear-gradient(45deg, #ffbb33, #ff4444);
        color: white;
        border-radius: 0px 0px 10px 10px;
    }

    marquee a {
        color: black;
        font-weight: bold;
        text-decoration: none;
        margin-right: 15px;
    }

    /* Form Styling */
    .form-group label {
        font-size: 16px;
        font-weight: 600;
        margin-bottom: 10px;
    }

    .form-control {
        border: 1px solid #ced4da;
        border-radius: 8px;
        padding: 10px;
    }

    .bttn-primary, .btn-danger {
        width: 100%;
        font-size: 18px;
        padding: 12px;
        border-radius: 8px;
        background-color: #626ED4;
        color: white;
    }

    .bttn-primary:hover, .btn-danger:hover {
        background-color: #0056b3;
        color: white;
    }

    .text-center {
        text-align: center;
    }

    .text-danger {
        color: #dc3545 !important;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('user-content'); ?>
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

<section>
    <?php if(session('withdraw_success')): ?>
        <div class="alert alert-success" style="font-weight:bold;">
            <i class="fas fa-check"></i>
            <span id="withdrawSuccessMessage" class="ms-3">Withdraw Success</span>
            <button type="button" class="close" onclick="closeWithdrawMessage()">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    <?php endif; ?>

        <div class="row justify-content-center">
            <div class="col-xl-3 order-xl-2">
                   <?php $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($data->approval == 0): ?>
                            <div class="alert alert-danger">
                                 <div class="rounded-circle-container">
                                    <p class="rounded-circle-content" style="font-size: 12px; margin: 0;">❗️</p>
                                 </div>
                                 <p style="font-weight: bold;">Dear <?php echo e(Auth::user()->name); ?> Sir,<br>Recently you have placed a withdraw. Please wait 1-24 business hours. We are reviewing..</p>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div class="card mt-2">
                    <div class="card-body">
                        <p class="text-muted font-weight-500">Earning Balance</p>
                        <div>
                            <span class="h6 surtitle text-muted">Name</span>
                            <span class="d-block h3"><?php echo e(Auth::user()->name); ?></span>
                        </div>
                        <div>
                            <span class="h6 surtitle text-muted">Balance</span>
                            <span class="d-block h3">$<?php echo e(number_format(Auth::user()->earning_balance, 3)); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        
    <?php if((site_info()->instanat_verify_active == 1 || site_info()->need_user_verification == 1) && Auth::user()->is_verified == 0): ?>
            <div class="col lg-6">
                <a href="<?php echo e(route('user.account-upgrade-page')); ?>">
                    <div class="card bg-gradient-orange">
                        <div class="card-body">
                            <h3 class="card-title text-white">Account Not Verified!</h3>
                            <p class="text-white mb-0">Please verify your account for withdraw.</p>
                        </div>
                    </div>
                </a>
            </div>
    <?php else: ?><div class="col-lg-8 col-md-8 col-12">
                <div class="alert alert-success bg-warning text-white border-0">
                    <marquee scrollamount="6">
                                                    <a href="#" class="text-black" style="font-size:20px;">
                                <i class="fe fe-link me-2" aria-hidden="true"></i>মাত্র 1$ ( 1 ডলার = 100 টাকা হলেই এই সাইট থেকে বিকাশ, নগদ ও রকেটের মাধ্যমে পেমেন্ট নিতে পারবেন
                            </a>
                                            </marquee>
                </div>
            </div>
            <div class="col-xl-6 order-xl-1">
                <div class="card">
                    <div class="card-header">
                        <h3 class="mb-0">Withdraw</h3>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('user.withdraw-store')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                        <div class="">
                               <p class="text-muted font-weight-500">Select Payment Method<span class="text-danger"></span></p>
                            <div class="row mb-4">
                                <?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-6">
                                        <div class="coinbase-methods-container">
                                            <input type="radio" id="wallet_<?php echo e($method->id); ?>" name="account_type" value="<?php echo e($method->name); ?>" data-fee="19" data-minimum="500" onclick="handlePaymentMethod(this)">
                                            <label class="coinbase-methods-label" for="wallet_<?php echo e($method->id); ?>">
                                                <img src="<?php echo e(URL::to($method->image)); ?>" style="height: 30px; width: 30px;" alt="Bkash"><span class="heading-small"><?php echo e($method->name); ?></span>
                                            </label>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                                <div class="col-md-6 d-none">
                                    <div class="coinbase-methods-container">
                                        <input type="radio" id="walletBkash" name="account_type" value="bKash" data-fee="19" data-minimum="500" onclick="handlePaymentMethod(this)">
                                        <label class="coinbase-methods-label" for="walletBkash">
                                            <img src="https://powerworkerearn.com/backend/img/website/bkash-logo.png" style="height: 30px; width: 30px;" alt="Bkash"><span class="heading-small">bKash</span>
                                        </label>
                                    </div>
                                </div>
                        
                                <div class="col-md-6 mb-4 d-none">
                                    <div class="coinbase-methods-container">
                                        <input type="radio" id="walletNagad" name="account_type" value="Nagad" data-fee="19" data-minimum="500" onclick="handlePaymentMethod(this)">
                                        <label class="coinbase-methods-label" for="walletNagad">
                                            <img src="https://powerworkerearn.com/backend/img/website/nagad-icon.png" style="height: 30px; width: 30px;" alt="Nagad"><span class="heading-small"> Nagad</span>
                                        </label>
                                    </div>
                                </div>
                                
                                    <p class="text-muted text-blue font-weight-500">Minimum $<?php echo e(number_format($withdraw_fee->minimum_withdraw, 2)); ?> (৳20) & Admin Fee <?php echo e($withdraw_fee->fee); ?>%</p>
                                
                            </div>

                            <p class="text-muted font-weight-500">Receive Account & Amount</p>
                          
                            <div class="form-group mb-2">
                                <div class="input-group input-group-merge">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-wallet"></i></span>
                                    </div>
                                    <input class="form-control" type="text" name="account_no" required placeholder="Receive Account Number">
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="input-group input-group-merge">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><small class="font-weight-bold">$</small></span>
                                            </div>
                                            <input class="form-control" type="number" name="withdraw_amount" id="withdraw_amount" value="" min="<?php echo e($withdraw_fee->minimum_withdraw); ?>" onkeyup="changeWithdrawAmount()" onchange="changeWithdrawAmount()" placeholder="Payment Amount">
                                        </div>
                                        <div style="margin-top: 8px;"></div>
                                        <small class="text-muted text-red font-weight-600" id="wallet-amount-info" style="margin-left: 2%; display: block;"></small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="input-group input-group-alternative">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text text-sm font-weight-bold text-uppercase" id="balance-info"></span>
                                            </div>
                                            <input type="hidden" class="form-control" name="withdraw_charge" id="withdraw_charge" value="" min="" readonly>
                                            <input type="number" class="form-control" name="amount" id="amount" value="" min="" placeholder="Payment Amount" readonly>
                                            <input type="hidden" class="form-control" name="admin_fee" id="admin_fee" value="<?php echo e($withdraw_fee->fee); ?>">
                                        </div>
                                        <span id="balance-info" class="text-danger"></span>
                                    </div>
                                </div>
                            </div>
                            
                            
                            <div class="form-group text-right">
                                <button 
                                    <?php if($withdraw_fee->minimum_withdraw > Auth::user()->earning_balance || Auth::user()->earning_balance == 0): ?> 
                                        type="button" disabled 
                                        class="btn btn-outline-warning mt-4 bttn" id="withdrawNew"
                                    <?php else: ?> 
                                        type="button" data-toggle="modal" data-target="#modalWithdraw"
                                        class="btn btn-outline-warning mt-4 bttn" id="withdrawNew"
                                    <?php endif; ?>
                                    ><i class="fas fa-check"></i>
                                    Withdraw
                                </button>
                            </div>
    
                           <div class="modal fade" id="modalWithdraw" tabindex="-1" role="dialog"
                                aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered" role="document">
                                    <div class="modal-content">
                                        <div class="modal-body">
                                           <h4 class="text-red">Sir,  Please check your information again.</h4>
                                           <br>
                                           <p class="tab-title-header h2">Are you confirm ?</p>
                                        </div>
                                      <div class="modal-footer">
                                          <button type="button" class="btn btn-success bttn" data-dismiss="modal" id="btnWithdrawPlace">Yes, Confirm</button>
                                          <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                                      </div>
                                  </div>
                              </div>
                           </div>
    
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</section>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>

<!-- Popper.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>

<!-- Bootstrap JS -->
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
        function setAccount(account_id){
            $('#deposit_account').val(account_id);

            $.ajax({
                url: "<?php echo e(route('user.deposit-account-info')); ?>",
                type:"POST",
                data:{
                    _token: '<?php echo e(csrf_token()); ?>',
                    account_id: account_id,
                },
                success:function(data) {
                    $('#deposit_area').show();
                    $('#deposit_account_text').html('Account No: '+data['account_no']);
                    $('#deposit_account_guideline').html(data['guideline']);
                },
            });
        }

        function changeWithdrawAmount(){
            var withdraw_amount = parseFloat($('#withdraw_amount').val());

            if(isNaN(withdraw_amount) || withdraw_amount == '') {
                withdraw_amount = parseFloat(0);
            }

            var admin_fee = parseFloat($('#admin_fee').val());

            var charge = parseFloat((admin_fee * withdraw_amount) / 100);

            var total_amount = withdraw_amount + charge;

            if(charge < 0){
                $('#withdraw_charge').val(0);
            }else{
                $('#withdraw_charge').val(charge);
            }

            if(total_amount < 0){
                $('#amount').val(0);
            }else{
                $('#amount').val(total_amount);
            }
        }
        
        function updatePayout() {
        let withdrawAmount = parseFloat($('#withdraw_amount').val());

        if (isNaN(withdrawAmount) || withdrawAmount < <?php echo e($withdraw_fee->minimum_withdraw); ?>) {
            $('#wallet-amount-info').text('');
            $('#wallet-amount-info').fadeIn();
            return;
        }

        let payoutAmount = withdrawAmount * 100;

        $('#wallet-amount-info').text(`$1 = 100 | Payout: ${payoutAmount.toFixed(0)}.0000 BDT`);
        $('#wallet-amount-info').fadeIn();
    }

    // Call the function when the amount changes
    $('#withdraw_amount').on('input', function() {
        updatePayout();
    });

    // Call the function on page load
    $(document).ready(function() {
        updatePayout();
    });
    
    function checkBalance() {
        var withdrawAmount = parseFloat($('#withdraw_amount').val()) || 0;
        var withdrawCharge = parseFloat($('#withdraw_charge').val()) || 0;
        var totalAmount = withdrawAmount + withdrawCharge;
        var earningBalance = parseFloat('<?php echo e(Auth::user()->earning_balance); ?>');

        if (totalAmount > earningBalance) {
            $('#balance-info').text('INSUFFICIENT').addClass('text-danger');
            $('#amount').addClass('over-balance');
            $('#withdrawNew').prop('disabled', true); // Disable the button
        } else {
            $('#balance-info').text('TOTAL').removeClass('text-danger');
            $('#amount').removeClass('over-balance');
            $('#withdrawNew').prop('disabled', false); // Enable the button
        }
    }

    // Call the function when the amount or charge changes
    $('#withdraw_amount, #withdraw_charge').on('input', function() {
        checkBalance();
    });

    // Call the function on page load
    $(document).ready(function() {
        checkBalance();
    });
    
    
</script>

<!-- Your existing script -->
<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Get the modal and the buttons
        var modal = document.getElementById('modalWithdraw');
        var confirmButton = document.getElementById('btnWithdrawPlace');

        // Attach a click event listener to the confirm button
        confirmButton.addEventListener('click', function () {
            // Find the closest form and submit it when the user confirms
            var form = confirmButton.closest('form');
            if (form) {
                form.submit();
            }
        });

        // Attach a hidden.bs.modal event listener to the modal
        $(modal).on('hidden.bs.modal', function () {
            // Reset the form if the modal is hidden
            // Optional: You can add additional reset logic if needed
            var form = confirmButton.closest('form');
            if (form) {
                form.reset();
            }
        });
    });
    
    function closeWithdrawMessage() {
        var withdrawMessage = document.querySelector('.alert-success');
        withdrawMessage.style.display = 'none';
    }
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/powerwor/public_html/resources/views/user/pages/new-withdraw.blade.php ENDPATH**/ ?>